package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ResourceId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DescribeContactEvaluationRequest(
    instanceId: InstanceId,
    evaluationId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeContactEvaluationRequest = {
    import DescribeContactEvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeContactEvaluationRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .evaluationId(ResourceId.unwrap(evaluationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeContactEvaluationRequest.ReadOnly =
    zio.aws.connect.model.DescribeContactEvaluationRequest.wrap(buildAwsValue())
}
object DescribeContactEvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeContactEvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeContactEvaluationRequest =
      zio.aws.connect.model
        .DescribeContactEvaluationRequest(instanceId, evaluationId)
    def instanceId: InstanceId
    def evaluationId: ResourceId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getEvaluationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactEvaluationRequest
  ) extends zio.aws.connect.model.DescribeContactEvaluationRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val evaluationId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactEvaluationRequest
  ): zio.aws.connect.model.DescribeContactEvaluationRequest.ReadOnly =
    new Wrapper(impl)
}
