package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeContactEvaluationResponse(
    evaluation: zio.aws.connect.model.Evaluation,
    evaluationForm: zio.aws.connect.model.EvaluationFormContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeContactEvaluationResponse = {
    import DescribeContactEvaluationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeContactEvaluationResponse
      .builder()
      .evaluation(evaluation.buildAwsValue())
      .evaluationForm(evaluationForm.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeContactEvaluationResponse.ReadOnly =
    zio.aws.connect.model.DescribeContactEvaluationResponse
      .wrap(buildAwsValue())
}
object DescribeContactEvaluationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeContactEvaluationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeContactEvaluationResponse =
      zio.aws.connect.model.DescribeContactEvaluationResponse(
        evaluation.asEditable,
        evaluationForm.asEditable
      )
    def evaluation: zio.aws.connect.model.Evaluation.ReadOnly
    def evaluationForm: zio.aws.connect.model.EvaluationFormContent.ReadOnly
    def getEvaluation
        : ZIO[Any, Nothing, zio.aws.connect.model.Evaluation.ReadOnly] =
      ZIO.succeed(evaluation)
    def getEvaluationForm: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.EvaluationFormContent.ReadOnly
    ] = ZIO.succeed(evaluationForm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactEvaluationResponse
  ) extends zio.aws.connect.model.DescribeContactEvaluationResponse.ReadOnly {
    override val evaluation: zio.aws.connect.model.Evaluation.ReadOnly =
      zio.aws.connect.model.Evaluation.wrap(impl.evaluation())
    override val evaluationForm
        : zio.aws.connect.model.EvaluationFormContent.ReadOnly =
      zio.aws.connect.model.EvaluationFormContent.wrap(impl.evaluationForm())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactEvaluationResponse
  ): zio.aws.connect.model.DescribeContactEvaluationResponse.ReadOnly =
    new Wrapper(impl)
}
