package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ContactFlowModuleId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DescribeContactFlowModuleRequest(
    instanceId: InstanceId,
    contactFlowModuleId: ContactFlowModuleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest = {
    import DescribeContactFlowModuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactFlowModuleId(
        ContactFlowModuleId.unwrap(contactFlowModuleId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeContactFlowModuleRequest.ReadOnly =
    zio.aws.connect.model.DescribeContactFlowModuleRequest.wrap(buildAwsValue())
}
object DescribeContactFlowModuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeContactFlowModuleRequest =
      zio.aws.connect.model
        .DescribeContactFlowModuleRequest(instanceId, contactFlowModuleId)
    def instanceId: InstanceId
    def contactFlowModuleId: ContactFlowModuleId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactFlowModuleId: ZIO[Any, Nothing, ContactFlowModuleId] =
      ZIO.succeed(contactFlowModuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest
  ) extends zio.aws.connect.model.DescribeContactFlowModuleRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactFlowModuleId: ContactFlowModuleId =
      zio.aws.connect.model.primitives
        .ContactFlowModuleId(impl.contactFlowModuleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest
  ): zio.aws.connect.model.DescribeContactFlowModuleRequest.ReadOnly =
    new Wrapper(impl)
}
