package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceStorageConfigResponse(
    storageConfig: Optional[zio.aws.connect.model.InstanceStorageConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigResponse = {
    import DescribeInstanceStorageConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigResponse
      .builder()
      .optionallyWith(storageConfig.map(value => value.buildAwsValue()))(
        _.storageConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeInstanceStorageConfigResponse.ReadOnly =
    zio.aws.connect.model.DescribeInstanceStorageConfigResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceStorageConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.DescribeInstanceStorageConfigResponse =
      zio.aws.connect.model.DescribeInstanceStorageConfigResponse(
        storageConfig.map(value => value.asEditable)
      )
    def storageConfig
        : Optional[zio.aws.connect.model.InstanceStorageConfig.ReadOnly]
    def getStorageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.InstanceStorageConfig.ReadOnly
    ] = AwsError.unwrapOptionField("storageConfig", storageConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigResponse
  ) extends zio.aws.connect.model.DescribeInstanceStorageConfigResponse.ReadOnly {
    override val storageConfig
        : Optional[zio.aws.connect.model.InstanceStorageConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageConfig())
        .map(value => zio.aws.connect.model.InstanceStorageConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigResponse
  ): zio.aws.connect.model.DescribeInstanceStorageConfigResponse.ReadOnly =
    new Wrapper(impl)
}
