package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePhoneNumberResponse(
    claimedPhoneNumberSummary: Optional[
      zio.aws.connect.model.ClaimedPhoneNumberSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribePhoneNumberResponse = {
    import DescribePhoneNumberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribePhoneNumberResponse
      .builder()
      .optionallyWith(
        claimedPhoneNumberSummary.map(value => value.buildAwsValue())
      )(_.claimedPhoneNumberSummary)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribePhoneNumberResponse.ReadOnly =
    zio.aws.connect.model.DescribePhoneNumberResponse.wrap(buildAwsValue())
}
object DescribePhoneNumberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribePhoneNumberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribePhoneNumberResponse =
      zio.aws.connect.model.DescribePhoneNumberResponse(
        claimedPhoneNumberSummary.map(value => value.asEditable)
      )
    def claimedPhoneNumberSummary
        : Optional[zio.aws.connect.model.ClaimedPhoneNumberSummary.ReadOnly]
    def getClaimedPhoneNumberSummary: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.ClaimedPhoneNumberSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "claimedPhoneNumberSummary",
      claimedPhoneNumberSummary
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribePhoneNumberResponse
  ) extends zio.aws.connect.model.DescribePhoneNumberResponse.ReadOnly {
    override val claimedPhoneNumberSummary
        : Optional[zio.aws.connect.model.ClaimedPhoneNumberSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.claimedPhoneNumberSummary())
        .map(value =>
          zio.aws.connect.model.ClaimedPhoneNumberSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribePhoneNumberResponse
  ): zio.aws.connect.model.DescribePhoneNumberResponse.ReadOnly = new Wrapper(
    impl
  )
}
