package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{PromptId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DescribePromptRequest(
    instanceId: InstanceId,
    promptId: PromptId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribePromptRequest = {
    import DescribePromptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribePromptRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .promptId(PromptId.unwrap(promptId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribePromptRequest.ReadOnly =
    zio.aws.connect.model.DescribePromptRequest.wrap(buildAwsValue())
}
object DescribePromptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribePromptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribePromptRequest =
      zio.aws.connect.model.DescribePromptRequest(instanceId, promptId)
    def instanceId: InstanceId
    def promptId: PromptId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getPromptId: ZIO[Any, Nothing, PromptId] = ZIO.succeed(promptId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribePromptRequest
  ) extends zio.aws.connect.model.DescribePromptRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val promptId: PromptId =
      zio.aws.connect.model.primitives.PromptId(impl.promptId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribePromptRequest
  ): zio.aws.connect.model.DescribePromptRequest.ReadOnly = new Wrapper(impl)
}
