package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePromptResponse(
    prompt: Optional[zio.aws.connect.model.Prompt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribePromptResponse = {
    import DescribePromptResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribePromptResponse
      .builder()
      .optionallyWith(prompt.map(value => value.buildAwsValue()))(_.prompt)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribePromptResponse.ReadOnly =
    zio.aws.connect.model.DescribePromptResponse.wrap(buildAwsValue())
}
object DescribePromptResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribePromptResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribePromptResponse =
      zio.aws.connect.model
        .DescribePromptResponse(prompt.map(value => value.asEditable))
    def prompt: Optional[zio.aws.connect.model.Prompt.ReadOnly]
    def getPrompt: ZIO[Any, AwsError, zio.aws.connect.model.Prompt.ReadOnly] =
      AwsError.unwrapOptionField("prompt", prompt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribePromptResponse
  ) extends zio.aws.connect.model.DescribePromptResponse.ReadOnly {
    override val prompt: Optional[zio.aws.connect.model.Prompt.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prompt())
        .map(value => zio.aws.connect.model.Prompt.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribePromptResponse
  ): zio.aws.connect.model.DescribePromptResponse.ReadOnly = new Wrapper(impl)
}
