package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{QueueId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DescribeQueueRequest(
    instanceId: InstanceId,
    queueId: QueueId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeQueueRequest = {
    import DescribeQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeQueueRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeQueueRequest.ReadOnly =
    zio.aws.connect.model.DescribeQueueRequest.wrap(buildAwsValue())
}
object DescribeQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeQueueRequest =
      zio.aws.connect.model.DescribeQueueRequest(instanceId, queueId)
    def instanceId: InstanceId
    def queueId: QueueId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeQueueRequest
  ) extends zio.aws.connect.model.DescribeQueueRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeQueueRequest
  ): zio.aws.connect.model.DescribeQueueRequest.ReadOnly = new Wrapper(impl)
}
