package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{RuleId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DescribeRuleRequest(instanceId: InstanceId, ruleId: RuleId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeRuleRequest = {
    import DescribeRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeRuleRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .ruleId(RuleId.unwrap(ruleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeRuleRequest.ReadOnly =
    zio.aws.connect.model.DescribeRuleRequest.wrap(buildAwsValue())
}
object DescribeRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeRuleRequest =
      zio.aws.connect.model.DescribeRuleRequest(instanceId, ruleId)
    def instanceId: InstanceId
    def ruleId: RuleId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getRuleId: ZIO[Any, Nothing, RuleId] = ZIO.succeed(ruleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeRuleRequest
  ) extends zio.aws.connect.model.DescribeRuleRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val ruleId: RuleId =
      zio.aws.connect.model.primitives.RuleId(impl.ruleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeRuleRequest
  ): zio.aws.connect.model.DescribeRuleRequest.ReadOnly = new Wrapper(impl)
}
