package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeRuleResponse(rule: zio.aws.connect.model.Rule) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeRuleResponse = {
    import DescribeRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeRuleResponse
      .builder()
      .rule(rule.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeRuleResponse.ReadOnly =
    zio.aws.connect.model.DescribeRuleResponse.wrap(buildAwsValue())
}
object DescribeRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeRuleResponse =
      zio.aws.connect.model.DescribeRuleResponse(rule.asEditable)
    def rule: zio.aws.connect.model.Rule.ReadOnly
    def getRule: ZIO[Any, Nothing, zio.aws.connect.model.Rule.ReadOnly] =
      ZIO.succeed(rule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeRuleResponse
  ) extends zio.aws.connect.model.DescribeRuleResponse.ReadOnly {
    override val rule: zio.aws.connect.model.Rule.ReadOnly =
      zio.aws.connect.model.Rule.wrap(impl.rule())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeRuleResponse
  ): zio.aws.connect.model.DescribeRuleResponse.ReadOnly = new Wrapper(impl)
}
