package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.TrafficDistributionGroupIdOrArn
import scala.jdk.CollectionConverters._
final case class DescribeTrafficDistributionGroupRequest(
    trafficDistributionGroupId: TrafficDistributionGroupIdOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupRequest = {
    import DescribeTrafficDistributionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupRequest
      .builder()
      .trafficDistributionGroupId(
        TrafficDistributionGroupIdOrArn.unwrap(
          trafficDistributionGroupId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeTrafficDistributionGroupRequest.ReadOnly =
    zio.aws.connect.model.DescribeTrafficDistributionGroupRequest
      .wrap(buildAwsValue())
}
object DescribeTrafficDistributionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.DescribeTrafficDistributionGroupRequest =
      zio.aws.connect.model
        .DescribeTrafficDistributionGroupRequest(trafficDistributionGroupId)
    def trafficDistributionGroupId: TrafficDistributionGroupIdOrArn
    def getTrafficDistributionGroupId
        : ZIO[Any, Nothing, TrafficDistributionGroupIdOrArn] =
      ZIO.succeed(trafficDistributionGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupRequest
  ) extends zio.aws.connect.model.DescribeTrafficDistributionGroupRequest.ReadOnly {
    override val trafficDistributionGroupId: TrafficDistributionGroupIdOrArn =
      zio.aws.connect.model.primitives
        .TrafficDistributionGroupIdOrArn(impl.trafficDistributionGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupRequest
  ): zio.aws.connect.model.DescribeTrafficDistributionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
