package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.InstanceId
import scala.jdk.CollectionConverters._
final case class DescribeUserHierarchyStructureRequest(instanceId: InstanceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest = {
    import DescribeUserHierarchyStructureRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DescribeUserHierarchyStructureRequest.ReadOnly =
    zio.aws.connect.model.DescribeUserHierarchyStructureRequest
      .wrap(buildAwsValue())
}
object DescribeUserHierarchyStructureRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.DescribeUserHierarchyStructureRequest =
      zio.aws.connect.model.DescribeUserHierarchyStructureRequest(instanceId)
    def instanceId: InstanceId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest
  ) extends zio.aws.connect.model.DescribeUserHierarchyStructureRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest
  ): zio.aws.connect.model.DescribeUserHierarchyStructureRequest.ReadOnly =
    new Wrapper(impl)
}
