package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{InstanceId, UserId}
import scala.jdk.CollectionConverters._
final case class DescribeUserRequest(userId: UserId, instanceId: InstanceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeUserRequest = {
    import DescribeUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeUserRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeUserRequest.ReadOnly =
    zio.aws.connect.model.DescribeUserRequest.wrap(buildAwsValue())
}
object DescribeUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeUserRequest =
      zio.aws.connect.model.DescribeUserRequest(userId, instanceId)
    def userId: UserId
    def instanceId: InstanceId
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserRequest
  ) extends zio.aws.connect.model.DescribeUserRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.connect.model.primitives.UserId(impl.userId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeUserRequest
  ): zio.aws.connect.model.DescribeUserRequest.ReadOnly = new Wrapper(impl)
}
