package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{VocabularyId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DescribeVocabularyRequest(
    instanceId: InstanceId,
    vocabularyId: VocabularyId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest = {
    import DescribeVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .vocabularyId(VocabularyId.unwrap(vocabularyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DescribeVocabularyRequest.ReadOnly =
    zio.aws.connect.model.DescribeVocabularyRequest.wrap(buildAwsValue())
}
object DescribeVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DescribeVocabularyRequest =
      zio.aws.connect.model.DescribeVocabularyRequest(instanceId, vocabularyId)
    def instanceId: InstanceId
    def vocabularyId: VocabularyId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getVocabularyId: ZIO[Any, Nothing, VocabularyId] =
      ZIO.succeed(vocabularyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest
  ) extends zio.aws.connect.model.DescribeVocabularyRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val vocabularyId: VocabularyId =
      zio.aws.connect.model.primitives.VocabularyId(impl.vocabularyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest
  ): zio.aws.connect.model.DescribeVocabularyRequest.ReadOnly = new Wrapper(
    impl
  )
}
