package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Dimensions(
    queue: Optional[zio.aws.connect.model.QueueReference] = Optional.Absent,
    channel: Optional[zio.aws.connect.model.Channel] = Optional.Absent,
    routingProfile: Optional[zio.aws.connect.model.RoutingProfileReference] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.Dimensions = {
    import Dimensions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Dimensions
      .builder()
      .optionallyWith(queue.map(value => value.buildAwsValue()))(_.queue)
      .optionallyWith(channel.map(value => value.unwrap))(_.channel)
      .optionallyWith(routingProfile.map(value => value.buildAwsValue()))(
        _.routingProfile
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Dimensions.ReadOnly =
    zio.aws.connect.model.Dimensions.wrap(buildAwsValue())
}
object Dimensions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.Dimensions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Dimensions =
      zio.aws.connect.model.Dimensions(
        queue.map(value => value.asEditable),
        channel.map(value => value),
        routingProfile.map(value => value.asEditable)
      )
    def queue: Optional[zio.aws.connect.model.QueueReference.ReadOnly]
    def channel: Optional[zio.aws.connect.model.Channel]
    def routingProfile
        : Optional[zio.aws.connect.model.RoutingProfileReference.ReadOnly]
    def getQueue
        : ZIO[Any, AwsError, zio.aws.connect.model.QueueReference.ReadOnly] =
      AwsError.unwrapOptionField("queue", queue)
    def getChannel: ZIO[Any, AwsError, zio.aws.connect.model.Channel] =
      AwsError.unwrapOptionField("channel", channel)
    def getRoutingProfile: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.RoutingProfileReference.ReadOnly
    ] = AwsError.unwrapOptionField("routingProfile", routingProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Dimensions
  ) extends zio.aws.connect.model.Dimensions.ReadOnly {
    override val queue
        : Optional[zio.aws.connect.model.QueueReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queue())
        .map(value => zio.aws.connect.model.QueueReference.wrap(value))
    override val channel: Optional[zio.aws.connect.model.Channel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channel())
        .map(value => zio.aws.connect.model.Channel.wrap(value))
    override val routingProfile
        : Optional[zio.aws.connect.model.RoutingProfileReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingProfile())
        .map(value => zio.aws.connect.model.RoutingProfileReference.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Dimensions
  ): zio.aws.connect.model.Dimensions.ReadOnly = new Wrapper(impl)
}
