package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{Origin, InstanceId}
import scala.jdk.CollectionConverters._
final case class DisassociateApprovedOriginRequest(
    instanceId: InstanceId,
    origin: Origin
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest = {
    import DisassociateApprovedOriginRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .origin(Origin.unwrap(origin): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DisassociateApprovedOriginRequest.ReadOnly =
    zio.aws.connect.model.DisassociateApprovedOriginRequest
      .wrap(buildAwsValue())
}
object DisassociateApprovedOriginRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DisassociateApprovedOriginRequest =
      zio.aws.connect.model
        .DisassociateApprovedOriginRequest(instanceId, origin)
    def instanceId: InstanceId
    def origin: Origin
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getOrigin: ZIO[Any, Nothing, Origin] = ZIO.succeed(origin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest
  ) extends zio.aws.connect.model.DisassociateApprovedOriginRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val origin: Origin =
      zio.aws.connect.model.primitives.Origin(impl.origin())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest
  ): zio.aws.connect.model.DisassociateApprovedOriginRequest.ReadOnly =
    new Wrapper(impl)
}
