package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.InstanceId
import scala.jdk.CollectionConverters._
final case class DisassociateBotRequest(
    instanceId: InstanceId,
    lexBot: Optional[zio.aws.connect.model.LexBot] = Optional.Absent,
    lexV2Bot: Optional[zio.aws.connect.model.LexV2Bot] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DisassociateBotRequest = {
    import DisassociateBotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DisassociateBotRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(lexBot.map(value => value.buildAwsValue()))(_.lexBot)
      .optionallyWith(lexV2Bot.map(value => value.buildAwsValue()))(_.lexV2Bot)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DisassociateBotRequest.ReadOnly =
    zio.aws.connect.model.DisassociateBotRequest.wrap(buildAwsValue())
}
object DisassociateBotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DisassociateBotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DisassociateBotRequest =
      zio.aws.connect.model.DisassociateBotRequest(
        instanceId,
        lexBot.map(value => value.asEditable),
        lexV2Bot.map(value => value.asEditable)
      )
    def instanceId: InstanceId
    def lexBot: Optional[zio.aws.connect.model.LexBot.ReadOnly]
    def lexV2Bot: Optional[zio.aws.connect.model.LexV2Bot.ReadOnly]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getLexBot: ZIO[Any, AwsError, zio.aws.connect.model.LexBot.ReadOnly] =
      AwsError.unwrapOptionField("lexBot", lexBot)
    def getLexV2Bot
        : ZIO[Any, AwsError, zio.aws.connect.model.LexV2Bot.ReadOnly] =
      AwsError.unwrapOptionField("lexV2Bot", lexV2Bot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DisassociateBotRequest
  ) extends zio.aws.connect.model.DisassociateBotRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val lexBot: Optional[zio.aws.connect.model.LexBot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lexBot())
        .map(value => zio.aws.connect.model.LexBot.wrap(value))
    override val lexV2Bot: Optional[zio.aws.connect.model.LexV2Bot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lexV2Bot())
        .map(value => zio.aws.connect.model.LexV2Bot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DisassociateBotRequest
  ): zio.aws.connect.model.DisassociateBotRequest.ReadOnly = new Wrapper(impl)
}
