package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{LexRegion, BotName, InstanceId}
import scala.jdk.CollectionConverters._
final case class DisassociateLexBotRequest(
    instanceId: InstanceId,
    botName: BotName,
    lexRegion: LexRegion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest = {
    import DisassociateLexBotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .botName(BotName.unwrap(botName): java.lang.String)
      .lexRegion(LexRegion.unwrap(lexRegion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DisassociateLexBotRequest.ReadOnly =
    zio.aws.connect.model.DisassociateLexBotRequest.wrap(buildAwsValue())
}
object DisassociateLexBotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DisassociateLexBotRequest =
      zio.aws.connect.model
        .DisassociateLexBotRequest(instanceId, botName, lexRegion)
    def instanceId: InstanceId
    def botName: BotName
    def lexRegion: LexRegion
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getBotName: ZIO[Any, Nothing, BotName] = ZIO.succeed(botName)
    def getLexRegion: ZIO[Any, Nothing, LexRegion] = ZIO.succeed(lexRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest
  ) extends zio.aws.connect.model.DisassociateLexBotRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val botName: BotName =
      zio.aws.connect.model.primitives.BotName(impl.botName())
    override val lexRegion: LexRegion =
      zio.aws.connect.model.primitives.LexRegion(impl.lexRegion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest
  ): zio.aws.connect.model.DisassociateLexBotRequest.ReadOnly = new Wrapper(
    impl
  )
}
