package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{InstanceId, PhoneNumberId}
import scala.jdk.CollectionConverters._
final case class DisassociatePhoneNumberContactFlowRequest(
    phoneNumberId: PhoneNumberId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest = {
    import DisassociatePhoneNumberContactFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest
      .builder()
      .phoneNumberId(PhoneNumberId.unwrap(phoneNumberId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DisassociatePhoneNumberContactFlowRequest.ReadOnly =
    zio.aws.connect.model.DisassociatePhoneNumberContactFlowRequest
      .wrap(buildAwsValue())
}
object DisassociatePhoneNumberContactFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.DisassociatePhoneNumberContactFlowRequest =
      zio.aws.connect.model
        .DisassociatePhoneNumberContactFlowRequest(phoneNumberId, instanceId)
    def phoneNumberId: PhoneNumberId
    def instanceId: InstanceId
    def getPhoneNumberId: ZIO[Any, Nothing, PhoneNumberId] =
      ZIO.succeed(phoneNumberId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest
  ) extends zio.aws.connect.model.DisassociatePhoneNumberContactFlowRequest.ReadOnly {
    override val phoneNumberId: PhoneNumberId =
      zio.aws.connect.model.primitives.PhoneNumberId(impl.phoneNumberId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest
  ): zio.aws.connect.model.DisassociatePhoneNumberContactFlowRequest.ReadOnly =
    new Wrapper(impl)
}
