package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{RoutingProfileId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DisassociateRoutingProfileQueuesRequest(
    instanceId: InstanceId,
    routingProfileId: RoutingProfileId,
    queueReferences: Iterable[
      zio.aws.connect.model.RoutingProfileQueueReference
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest = {
    import DisassociateRoutingProfileQueuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .routingProfileId(
        RoutingProfileId.unwrap(routingProfileId): java.lang.String
      )
      .queueReferences(queueReferences.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DisassociateRoutingProfileQueuesRequest.ReadOnly =
    zio.aws.connect.model.DisassociateRoutingProfileQueuesRequest
      .wrap(buildAwsValue())
}
object DisassociateRoutingProfileQueuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.DisassociateRoutingProfileQueuesRequest =
      zio.aws.connect.model.DisassociateRoutingProfileQueuesRequest(
        instanceId,
        routingProfileId,
        queueReferences.map { item =>
          item.asEditable
        }
      )
    def instanceId: InstanceId
    def routingProfileId: RoutingProfileId
    def queueReferences
        : List[zio.aws.connect.model.RoutingProfileQueueReference.ReadOnly]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getRoutingProfileId: ZIO[Any, Nothing, RoutingProfileId] =
      ZIO.succeed(routingProfileId)
    def getQueueReferences: ZIO[Any, Nothing, List[
      zio.aws.connect.model.RoutingProfileQueueReference.ReadOnly
    ]] = ZIO.succeed(queueReferences)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest
  ) extends zio.aws.connect.model.DisassociateRoutingProfileQueuesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val routingProfileId: RoutingProfileId =
      zio.aws.connect.model.primitives.RoutingProfileId(impl.routingProfileId())
    override val queueReferences
        : List[zio.aws.connect.model.RoutingProfileQueueReference.ReadOnly] =
      impl
        .queueReferences()
        .asScala
        .map { item =>
          zio.aws.connect.model.RoutingProfileQueueReference.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest
  ): zio.aws.connect.model.DisassociateRoutingProfileQueuesRequest.ReadOnly =
    new Wrapper(impl)
}
