package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  InstanceId,
  UserId,
  TrafficDistributionGroupIdOrArn
}
import scala.jdk.CollectionConverters._
final case class DisassociateTrafficDistributionGroupUserRequest(
    trafficDistributionGroupId: TrafficDistributionGroupIdOrArn,
    userId: UserId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserRequest = {
    import DisassociateTrafficDistributionGroupUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserRequest
      .builder()
      .trafficDistributionGroupId(
        TrafficDistributionGroupIdOrArn.unwrap(
          trafficDistributionGroupId
        ): java.lang.String
      )
      .userId(UserId.unwrap(userId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DisassociateTrafficDistributionGroupUserRequest.ReadOnly =
    zio.aws.connect.model.DisassociateTrafficDistributionGroupUserRequest
      .wrap(buildAwsValue())
}
object DisassociateTrafficDistributionGroupUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.DisassociateTrafficDistributionGroupUserRequest =
      zio.aws.connect.model.DisassociateTrafficDistributionGroupUserRequest(
        trafficDistributionGroupId,
        userId,
        instanceId
      )
    def trafficDistributionGroupId: TrafficDistributionGroupIdOrArn
    def userId: UserId
    def instanceId: InstanceId
    def getTrafficDistributionGroupId
        : ZIO[Any, Nothing, TrafficDistributionGroupIdOrArn] =
      ZIO.succeed(trafficDistributionGroupId)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserRequest
  ) extends zio.aws.connect.model.DisassociateTrafficDistributionGroupUserRequest.ReadOnly {
    override val trafficDistributionGroupId: TrafficDistributionGroupIdOrArn =
      zio.aws.connect.model.primitives
        .TrafficDistributionGroupIdOrArn(impl.trafficDistributionGroupId())
    override val userId: UserId =
      zio.aws.connect.model.primitives.UserId(impl.userId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserRequest
  ): zio.aws.connect.model.DisassociateTrafficDistributionGroupUserRequest.ReadOnly =
    new Wrapper(impl)
}
