package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ContactId, InstanceId, UserId}
import scala.jdk.CollectionConverters._
final case class DismissUserContactRequest(
    userId: UserId,
    instanceId: InstanceId,
    contactId: ContactId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DismissUserContactRequest = {
    import DismissUserContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DismissUserContactRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DismissUserContactRequest.ReadOnly =
    zio.aws.connect.model.DismissUserContactRequest.wrap(buildAwsValue())
}
object DismissUserContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DismissUserContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DismissUserContactRequest =
      zio.aws.connect.model
        .DismissUserContactRequest(userId, instanceId, contactId)
    def userId: UserId
    def instanceId: InstanceId
    def contactId: ContactId
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DismissUserContactRequest
  ) extends zio.aws.connect.model.DismissUserContactRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.connect.model.primitives.UserId(impl.userId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DismissUserContactRequest
  ): zio.aws.connect.model.DismissUserContactRequest.ReadOnly = new Wrapper(
    impl
  )
}
