package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ReferenceValue, ReferenceKey}
import scala.jdk.CollectionConverters._
final case class EmailReference(
    name: Optional[ReferenceKey] = Optional.Absent,
    value: Optional[ReferenceValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EmailReference = {
    import EmailReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EmailReference
      .builder()
      .optionallyWith(
        name.map(value => ReferenceKey.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => ReferenceValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EmailReference.ReadOnly =
    zio.aws.connect.model.EmailReference.wrap(buildAwsValue())
}
object EmailReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EmailReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EmailReference = zio.aws.connect.model
      .EmailReference(name.map(value => value), value.map(value => value))
    def name: Optional[ReferenceKey]
    def value: Optional[ReferenceValue]
    def getName: ZIO[Any, AwsError, ReferenceKey] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, ReferenceValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EmailReference
  ) extends zio.aws.connect.model.EmailReference.ReadOnly {
    override val name: Optional[ReferenceKey] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.ReferenceKey(value))
    override val value: Optional[ReferenceValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.connect.model.primitives.ReferenceValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EmailReference
  ): zio.aws.connect.model.EmailReference.ReadOnly = new Wrapper(impl)
}
