package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.KeyId
import scala.jdk.CollectionConverters._
final case class EncryptionConfig(
    encryptionType: zio.aws.connect.model.EncryptionType,
    keyId: KeyId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EncryptionConfig = {
    import EncryptionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EncryptionConfig
      .builder()
      .encryptionType(encryptionType.unwrap)
      .keyId(KeyId.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EncryptionConfig.ReadOnly =
    zio.aws.connect.model.EncryptionConfig.wrap(buildAwsValue())
}
object EncryptionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EncryptionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EncryptionConfig =
      zio.aws.connect.model.EncryptionConfig(encryptionType, keyId)
    def encryptionType: zio.aws.connect.model.EncryptionType
    def keyId: KeyId
    def getEncryptionType
        : ZIO[Any, Nothing, zio.aws.connect.model.EncryptionType] =
      ZIO.succeed(encryptionType)
    def getKeyId: ZIO[Any, Nothing, KeyId] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EncryptionConfig
  ) extends zio.aws.connect.model.EncryptionConfig.ReadOnly {
    override val encryptionType: zio.aws.connect.model.EncryptionType =
      zio.aws.connect.model.EncryptionType.wrap(impl.encryptionType())
    override val keyId: KeyId =
      zio.aws.connect.model.primitives.KeyId(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EncryptionConfig
  ): zio.aws.connect.model.EncryptionConfig.ReadOnly = new Wrapper(impl)
}
