package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  Timestamp,
  TagValue,
  ResourceId,
  ARN,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Evaluation(
    evaluationId: ResourceId,
    evaluationArn: ARN,
    metadata: zio.aws.connect.model.EvaluationMetadata,
    answers: Map[ResourceId, zio.aws.connect.model.EvaluationAnswerOutput],
    notes: Map[ResourceId, zio.aws.connect.model.EvaluationNote],
    status: zio.aws.connect.model.EvaluationStatus,
    scores: Optional[Map[ResourceId, zio.aws.connect.model.EvaluationScore]] =
      Optional.Absent,
    createdTime: Timestamp,
    lastModifiedTime: Timestamp,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.Evaluation = {
    import Evaluation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Evaluation
      .builder()
      .evaluationId(ResourceId.unwrap(evaluationId): java.lang.String)
      .evaluationArn(ARN.unwrap(evaluationArn): java.lang.String)
      .metadata(metadata.buildAwsValue())
      .answers(
        answers
          .map({ case (key, value) =>
            (ResourceId.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .notes(
        notes
          .map({ case (key, value) =>
            (ResourceId.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .status(status.unwrap)
      .optionallyWith(
        scores.map(value =>
          value
            .map({ case (key, value) =>
              (ResourceId.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.scores)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Evaluation.ReadOnly =
    zio.aws.connect.model.Evaluation.wrap(buildAwsValue())
}
object Evaluation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.Evaluation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Evaluation =
      zio.aws.connect.model.Evaluation(
        evaluationId,
        evaluationArn,
        metadata.asEditable,
        answers.map({ case (key, value) =>
          key -> value.asEditable
        }),
        notes.map({ case (key, value) =>
          key -> value.asEditable
        }),
        status,
        scores.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        createdTime,
        lastModifiedTime,
        tags.map(value => value)
      )
    def evaluationId: ResourceId
    def evaluationArn: ARN
    def metadata: zio.aws.connect.model.EvaluationMetadata.ReadOnly
    def answers
        : Map[ResourceId, zio.aws.connect.model.EvaluationAnswerOutput.ReadOnly]
    def notes: Map[ResourceId, zio.aws.connect.model.EvaluationNote.ReadOnly]
    def status: zio.aws.connect.model.EvaluationStatus
    def scores: Optional[
      Map[ResourceId, zio.aws.connect.model.EvaluationScore.ReadOnly]
    ]
    def createdTime: Timestamp
    def lastModifiedTime: Timestamp
    def tags: Optional[Map[TagKey, TagValue]]
    def getEvaluationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationId)
    def getEvaluationArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(evaluationArn)
    def getMetadata
        : ZIO[Any, Nothing, zio.aws.connect.model.EvaluationMetadata.ReadOnly] =
      ZIO.succeed(metadata)
    def getAnswers: ZIO[Any, Nothing, Map[
      ResourceId,
      zio.aws.connect.model.EvaluationAnswerOutput.ReadOnly
    ]] = ZIO.succeed(answers)
    def getNotes: ZIO[Any, Nothing, Map[
      ResourceId,
      zio.aws.connect.model.EvaluationNote.ReadOnly
    ]] = ZIO.succeed(notes)
    def getStatus: ZIO[Any, Nothing, zio.aws.connect.model.EvaluationStatus] =
      ZIO.succeed(status)
    def getScores: ZIO[Any, AwsError, Map[
      ResourceId,
      zio.aws.connect.model.EvaluationScore.ReadOnly
    ]] = AwsError.unwrapOptionField("scores", scores)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Evaluation
  ) extends zio.aws.connect.model.Evaluation.ReadOnly {
    override val evaluationId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationId())
    override val evaluationArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluationArn())
    override val metadata: zio.aws.connect.model.EvaluationMetadata.ReadOnly =
      zio.aws.connect.model.EvaluationMetadata.wrap(impl.metadata())
    override val answers: Map[
      ResourceId,
      zio.aws.connect.model.EvaluationAnswerOutput.ReadOnly
    ] = impl
      .answers()
      .asScala
      .map({ case (key, value) =>
        zio.aws.connect.model.primitives.ResourceId(
          key
        ) -> zio.aws.connect.model.EvaluationAnswerOutput.wrap(value)
      })
      .toMap
    override val notes
        : Map[ResourceId, zio.aws.connect.model.EvaluationNote.ReadOnly] = impl
      .notes()
      .asScala
      .map({ case (key, value) =>
        zio.aws.connect.model.primitives
          .ResourceId(key) -> zio.aws.connect.model.EvaluationNote.wrap(value)
      })
      .toMap
    override val status: zio.aws.connect.model.EvaluationStatus =
      zio.aws.connect.model.EvaluationStatus.wrap(impl.status())
    override val scores: Optional[
      Map[ResourceId, zio.aws.connect.model.EvaluationScore.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scores())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives.ResourceId(
              key
            ) -> zio.aws.connect.model.EvaluationScore.wrap(value)
          })
          .toMap
      )
    override val createdTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.createdTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.lastModifiedTime())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Evaluation
  ): zio.aws.connect.model.Evaluation.ReadOnly = new Wrapper(impl)
}
