package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  EvaluationAnswerDataNumericValue,
  EvaluationAnswerDataStringValue
}
import scala.jdk.CollectionConverters._
final case class EvaluationAnswerData(
    stringValue: Optional[EvaluationAnswerDataStringValue] = Optional.Absent,
    numericValue: Optional[EvaluationAnswerDataNumericValue] = Optional.Absent,
    notApplicable: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationAnswerData = {
    import EvaluationAnswerData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationAnswerData
      .builder()
      .optionallyWith(
        stringValue.map(value =>
          EvaluationAnswerDataStringValue.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .optionallyWith(
        numericValue.map(value =>
          EvaluationAnswerDataNumericValue.unwrap(value): java.lang.Double
        )
      )(_.numericValue)
      .optionallyWith(notApplicable.map(value => value: java.lang.Boolean))(
        _.notApplicable
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationAnswerData.ReadOnly =
    zio.aws.connect.model.EvaluationAnswerData.wrap(buildAwsValue())
}
object EvaluationAnswerData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationAnswerData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationAnswerData =
      zio.aws.connect.model.EvaluationAnswerData(
        stringValue.map(value => value),
        numericValue.map(value => value),
        notApplicable.map(value => value)
      )
    def stringValue: Optional[EvaluationAnswerDataStringValue]
    def numericValue: Optional[EvaluationAnswerDataNumericValue]
    def notApplicable: Optional[Boolean]
    def getStringValue: ZIO[Any, AwsError, EvaluationAnswerDataStringValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getNumericValue: ZIO[Any, AwsError, EvaluationAnswerDataNumericValue] =
      AwsError.unwrapOptionField("numericValue", numericValue)
    def getNotApplicable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("notApplicable", notApplicable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationAnswerData
  ) extends zio.aws.connect.model.EvaluationAnswerData.ReadOnly {
    override val stringValue: Optional[EvaluationAnswerDataStringValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringValue())
        .map(value =>
          zio.aws.connect.model.primitives
            .EvaluationAnswerDataStringValue(value)
        )
    override val numericValue: Optional[EvaluationAnswerDataNumericValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numericValue())
        .map(value =>
          zio.aws.connect.model.primitives
            .EvaluationAnswerDataNumericValue(value)
        )
    override val notApplicable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.notApplicable())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationAnswerData
  ): zio.aws.connect.model.EvaluationAnswerData.ReadOnly = new Wrapper(impl)
}
