package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationAnswerInput(
    value: Optional[zio.aws.connect.model.EvaluationAnswerData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationAnswerInput = {
    import EvaluationAnswerInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationAnswerInput
      .builder()
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationAnswerInput.ReadOnly =
    zio.aws.connect.model.EvaluationAnswerInput.wrap(buildAwsValue())
}
object EvaluationAnswerInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationAnswerInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationAnswerInput =
      zio.aws.connect.model
        .EvaluationAnswerInput(value.map(value => value.asEditable))
    def value: Optional[zio.aws.connect.model.EvaluationAnswerData.ReadOnly]
    def getValue: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationAnswerData.ReadOnly
    ] = AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationAnswerInput
  ) extends zio.aws.connect.model.EvaluationAnswerInput.ReadOnly {
    override val value
        : Optional[zio.aws.connect.model.EvaluationAnswerData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.connect.model.EvaluationAnswerData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationAnswerInput
  ): zio.aws.connect.model.EvaluationAnswerInput.ReadOnly = new Wrapper(impl)
}
