package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationAnswerOutput(
    value: Optional[zio.aws.connect.model.EvaluationAnswerData] =
      Optional.Absent,
    systemSuggestedValue: Optional[zio.aws.connect.model.EvaluationAnswerData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationAnswerOutput = {
    import EvaluationAnswerOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationAnswerOutput
      .builder()
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .optionallyWith(systemSuggestedValue.map(value => value.buildAwsValue()))(
        _.systemSuggestedValue
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationAnswerOutput.ReadOnly =
    zio.aws.connect.model.EvaluationAnswerOutput.wrap(buildAwsValue())
}
object EvaluationAnswerOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationAnswerOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationAnswerOutput =
      zio.aws.connect.model.EvaluationAnswerOutput(
        value.map(value => value.asEditable),
        systemSuggestedValue.map(value => value.asEditable)
      )
    def value: Optional[zio.aws.connect.model.EvaluationAnswerData.ReadOnly]
    def systemSuggestedValue
        : Optional[zio.aws.connect.model.EvaluationAnswerData.ReadOnly]
    def getValue: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationAnswerData.ReadOnly
    ] = AwsError.unwrapOptionField("value", value)
    def getSystemSuggestedValue: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationAnswerData.ReadOnly
    ] = AwsError.unwrapOptionField("systemSuggestedValue", systemSuggestedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationAnswerOutput
  ) extends zio.aws.connect.model.EvaluationAnswerOutput.ReadOnly {
    override val value
        : Optional[zio.aws.connect.model.EvaluationAnswerData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.connect.model.EvaluationAnswerData.wrap(value))
    override val systemSuggestedValue
        : Optional[zio.aws.connect.model.EvaluationAnswerData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.systemSuggestedValue())
        .map(value => zio.aws.connect.model.EvaluationAnswerData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationAnswerOutput
  ): zio.aws.connect.model.EvaluationAnswerOutput.ReadOnly = new Wrapper(impl)
}
