package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  EvaluationFormDescription,
  Timestamp,
  TagValue,
  EvaluationFormVersionIsLocked,
  VersionNumber,
  ResourceId,
  EvaluationFormTitle,
  ARN,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EvaluationForm(
    evaluationFormId: ResourceId,
    evaluationFormVersion: VersionNumber,
    locked: EvaluationFormVersionIsLocked,
    evaluationFormArn: ARN,
    title: EvaluationFormTitle,
    description: Optional[EvaluationFormDescription] = Optional.Absent,
    status: zio.aws.connect.model.EvaluationFormVersionStatus,
    items: Iterable[zio.aws.connect.model.EvaluationFormItem],
    scoringStrategy: Optional[
      zio.aws.connect.model.EvaluationFormScoringStrategy
    ] = Optional.Absent,
    createdTime: Timestamp,
    createdBy: ARN,
    lastModifiedTime: Timestamp,
    lastModifiedBy: ARN,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationForm = {
    import EvaluationForm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationForm
      .builder()
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .evaluationFormVersion(
        VersionNumber.unwrap(evaluationFormVersion): Integer
      )
      .locked(EvaluationFormVersionIsLocked.unwrap(locked): java.lang.Boolean)
      .evaluationFormArn(ARN.unwrap(evaluationFormArn): java.lang.String)
      .title(EvaluationFormTitle.unwrap(title): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EvaluationFormDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .status(status.unwrap)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(scoringStrategy.map(value => value.buildAwsValue()))(
        _.scoringStrategy
      )
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .createdBy(ARN.unwrap(createdBy): java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .lastModifiedBy(ARN.unwrap(lastModifiedBy): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationForm.ReadOnly =
    zio.aws.connect.model.EvaluationForm.wrap(buildAwsValue())
}
object EvaluationForm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationForm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationForm =
      zio.aws.connect.model.EvaluationForm(
        evaluationFormId,
        evaluationFormVersion,
        locked,
        evaluationFormArn,
        title,
        description.map(value => value),
        status,
        items.map { item =>
          item.asEditable
        },
        scoringStrategy.map(value => value.asEditable),
        createdTime,
        createdBy,
        lastModifiedTime,
        lastModifiedBy,
        tags.map(value => value)
      )
    def evaluationFormId: ResourceId
    def evaluationFormVersion: VersionNumber
    def locked: EvaluationFormVersionIsLocked
    def evaluationFormArn: ARN
    def title: EvaluationFormTitle
    def description: Optional[EvaluationFormDescription]
    def status: zio.aws.connect.model.EvaluationFormVersionStatus
    def items: List[zio.aws.connect.model.EvaluationFormItem.ReadOnly]
    def scoringStrategy
        : Optional[zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly]
    def createdTime: Timestamp
    def createdBy: ARN
    def lastModifiedTime: Timestamp
    def lastModifiedBy: ARN
    def tags: Optional[Map[TagKey, TagValue]]
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getEvaluationFormVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(evaluationFormVersion)
    def getLocked: ZIO[Any, Nothing, EvaluationFormVersionIsLocked] =
      ZIO.succeed(locked)
    def getEvaluationFormArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(evaluationFormArn)
    def getTitle: ZIO[Any, Nothing, EvaluationFormTitle] = ZIO.succeed(title)
    def getDescription: ZIO[Any, AwsError, EvaluationFormDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.connect.model.EvaluationFormVersionStatus] =
      ZIO.succeed(status)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.connect.model.EvaluationFormItem.ReadOnly
    ]] = ZIO.succeed(items)
    def getScoringStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly
    ] = AwsError.unwrapOptionField("scoringStrategy", scoringStrategy)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getCreatedBy: ZIO[Any, Nothing, ARN] = ZIO.succeed(createdBy)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getLastModifiedBy: ZIO[Any, Nothing, ARN] = ZIO.succeed(lastModifiedBy)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationForm
  ) extends zio.aws.connect.model.EvaluationForm.ReadOnly {
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val evaluationFormVersion: VersionNumber =
      zio.aws.connect.model.primitives
        .VersionNumber(impl.evaluationFormVersion())
    override val locked: EvaluationFormVersionIsLocked =
      zio.aws.connect.model.primitives
        .EvaluationFormVersionIsLocked(impl.locked())
    override val evaluationFormArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluationFormArn())
    override val title: EvaluationFormTitle =
      zio.aws.connect.model.primitives.EvaluationFormTitle(impl.title())
    override val description: Optional[EvaluationFormDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.EvaluationFormDescription(value)
        )
    override val status: zio.aws.connect.model.EvaluationFormVersionStatus =
      zio.aws.connect.model.EvaluationFormVersionStatus.wrap(impl.status())
    override val items
        : List[zio.aws.connect.model.EvaluationFormItem.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.connect.model.EvaluationFormItem.wrap(item)
      }
      .toList
    override val scoringStrategy: Optional[
      zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scoringStrategy())
      .map(value =>
        zio.aws.connect.model.EvaluationFormScoringStrategy.wrap(value)
      )
    override val createdTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.createdTime())
    override val createdBy: ARN =
      zio.aws.connect.model.primitives.ARN(impl.createdBy())
    override val lastModifiedTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.lastModifiedTime())
    override val lastModifiedBy: ARN =
      zio.aws.connect.model.primitives.ARN(impl.lastModifiedBy())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationForm
  ): zio.aws.connect.model.EvaluationForm.ReadOnly = new Wrapper(impl)
}
