package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  EvaluationFormDescription,
  VersionNumber,
  ResourceId,
  EvaluationFormTitle,
  ARN
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EvaluationFormContent(
    evaluationFormVersion: VersionNumber,
    evaluationFormId: ResourceId,
    evaluationFormArn: ARN,
    title: EvaluationFormTitle,
    description: Optional[EvaluationFormDescription] = Optional.Absent,
    items: Iterable[zio.aws.connect.model.EvaluationFormItem],
    scoringStrategy: Optional[
      zio.aws.connect.model.EvaluationFormScoringStrategy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormContent = {
    import EvaluationFormContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormContent
      .builder()
      .evaluationFormVersion(
        VersionNumber.unwrap(evaluationFormVersion): Integer
      )
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .evaluationFormArn(ARN.unwrap(evaluationFormArn): java.lang.String)
      .title(EvaluationFormTitle.unwrap(title): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EvaluationFormDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(scoringStrategy.map(value => value.buildAwsValue()))(
        _.scoringStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationFormContent.ReadOnly =
    zio.aws.connect.model.EvaluationFormContent.wrap(buildAwsValue())
}
object EvaluationFormContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationFormContent =
      zio.aws.connect.model.EvaluationFormContent(
        evaluationFormVersion,
        evaluationFormId,
        evaluationFormArn,
        title,
        description.map(value => value),
        items.map { item =>
          item.asEditable
        },
        scoringStrategy.map(value => value.asEditable)
      )
    def evaluationFormVersion: VersionNumber
    def evaluationFormId: ResourceId
    def evaluationFormArn: ARN
    def title: EvaluationFormTitle
    def description: Optional[EvaluationFormDescription]
    def items: List[zio.aws.connect.model.EvaluationFormItem.ReadOnly]
    def scoringStrategy
        : Optional[zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly]
    def getEvaluationFormVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(evaluationFormVersion)
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getEvaluationFormArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(evaluationFormArn)
    def getTitle: ZIO[Any, Nothing, EvaluationFormTitle] = ZIO.succeed(title)
    def getDescription: ZIO[Any, AwsError, EvaluationFormDescription] =
      AwsError.unwrapOptionField("description", description)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.connect.model.EvaluationFormItem.ReadOnly
    ]] = ZIO.succeed(items)
    def getScoringStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly
    ] = AwsError.unwrapOptionField("scoringStrategy", scoringStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormContent
  ) extends zio.aws.connect.model.EvaluationFormContent.ReadOnly {
    override val evaluationFormVersion: VersionNumber =
      zio.aws.connect.model.primitives
        .VersionNumber(impl.evaluationFormVersion())
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val evaluationFormArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluationFormArn())
    override val title: EvaluationFormTitle =
      zio.aws.connect.model.primitives.EvaluationFormTitle(impl.title())
    override val description: Optional[EvaluationFormDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.EvaluationFormDescription(value)
        )
    override val items
        : List[zio.aws.connect.model.EvaluationFormItem.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.connect.model.EvaluationFormItem.wrap(item)
      }
      .toList
    override val scoringStrategy: Optional[
      zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scoringStrategy())
      .map(value =>
        zio.aws.connect.model.EvaluationFormScoringStrategy.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormContent
  ): zio.aws.connect.model.EvaluationFormContent.ReadOnly = new Wrapper(impl)
}
