package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationFormItem(
    section: Optional[zio.aws.connect.model.EvaluationFormSection] =
      Optional.Absent,
    question: Optional[zio.aws.connect.model.EvaluationFormQuestion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormItem = {
    import EvaluationFormItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormItem
      .builder()
      .optionallyWith(section.map(value => value.buildAwsValue()))(_.section)
      .optionallyWith(question.map(value => value.buildAwsValue()))(_.question)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationFormItem.ReadOnly =
    zio.aws.connect.model.EvaluationFormItem.wrap(buildAwsValue())
}
object EvaluationFormItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationFormItem =
      zio.aws.connect.model.EvaluationFormItem(
        section.map(value => value.asEditable),
        question.map(value => value.asEditable)
      )
    def section: Optional[zio.aws.connect.model.EvaluationFormSection.ReadOnly]
    def question
        : Optional[zio.aws.connect.model.EvaluationFormQuestion.ReadOnly]
    def getSection: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormSection.ReadOnly
    ] = AwsError.unwrapOptionField("section", section)
    def getQuestion: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormQuestion.ReadOnly
    ] = AwsError.unwrapOptionField("question", question)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormItem
  ) extends zio.aws.connect.model.EvaluationFormItem.ReadOnly {
    override val section
        : Optional[zio.aws.connect.model.EvaluationFormSection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.section())
        .map(value => zio.aws.connect.model.EvaluationFormSection.wrap(value))
    override val question
        : Optional[zio.aws.connect.model.EvaluationFormQuestion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.question())
        .map(value => zio.aws.connect.model.EvaluationFormQuestion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormItem
  ): zio.aws.connect.model.EvaluationFormItem.ReadOnly = new Wrapper(impl)
}
