package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationFormNumericQuestionAutomation(
    propertyValue: Optional[
      zio.aws.connect.model.NumericQuestionPropertyValueAutomation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionAutomation = {
    import EvaluationFormNumericQuestionAutomation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionAutomation
      .builder()
      .optionallyWith(propertyValue.map(value => value.buildAwsValue()))(
        _.propertyValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.EvaluationFormNumericQuestionAutomation.ReadOnly =
    zio.aws.connect.model.EvaluationFormNumericQuestionAutomation
      .wrap(buildAwsValue())
}
object EvaluationFormNumericQuestionAutomation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionAutomation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.EvaluationFormNumericQuestionAutomation =
      zio.aws.connect.model.EvaluationFormNumericQuestionAutomation(
        propertyValue.map(value => value.asEditable)
      )
    def propertyValue: Optional[
      zio.aws.connect.model.NumericQuestionPropertyValueAutomation.ReadOnly
    ]
    def getPropertyValue: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.NumericQuestionPropertyValueAutomation.ReadOnly
    ] = AwsError.unwrapOptionField("propertyValue", propertyValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionAutomation
  ) extends zio.aws.connect.model.EvaluationFormNumericQuestionAutomation.ReadOnly {
    override val propertyValue: Optional[
      zio.aws.connect.model.NumericQuestionPropertyValueAutomation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyValue())
      .map(value =>
        zio.aws.connect.model.NumericQuestionPropertyValueAutomation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionAutomation
  ): zio.aws.connect.model.EvaluationFormNumericQuestionAutomation.ReadOnly =
    new Wrapper(impl)
}
