package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  EvaluationFormQuestionAnswerScore,
  Integer
}
import scala.jdk.CollectionConverters._
final case class EvaluationFormNumericQuestionOption(
    minValue: Integer,
    maxValue: Integer,
    score: Optional[EvaluationFormQuestionAnswerScore] = Optional.Absent,
    automaticFail: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionOption = {
    import EvaluationFormNumericQuestionOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionOption
      .builder()
      .minValue(minValue: java.lang.Integer)
      .maxValue(maxValue: java.lang.Integer)
      .optionallyWith(
        score.map(value =>
          EvaluationFormQuestionAnswerScore.unwrap(value): java.lang.Integer
        )
      )(_.score)
      .optionallyWith(automaticFail.map(value => value: java.lang.Boolean))(
        _.automaticFail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.EvaluationFormNumericQuestionOption.ReadOnly =
    zio.aws.connect.model.EvaluationFormNumericQuestionOption
      .wrap(buildAwsValue())
}
object EvaluationFormNumericQuestionOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationFormNumericQuestionOption =
      zio.aws.connect.model.EvaluationFormNumericQuestionOption(
        minValue,
        maxValue,
        score.map(value => value),
        automaticFail.map(value => value)
      )
    def minValue: Integer
    def maxValue: Integer
    def score: Optional[EvaluationFormQuestionAnswerScore]
    def automaticFail: Optional[Boolean]
    def getMinValue: ZIO[Any, Nothing, Integer] = ZIO.succeed(minValue)
    def getMaxValue: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxValue)
    def getScore: ZIO[Any, AwsError, EvaluationFormQuestionAnswerScore] =
      AwsError.unwrapOptionField("score", score)
    def getAutomaticFail: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("automaticFail", automaticFail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionOption
  ) extends zio.aws.connect.model.EvaluationFormNumericQuestionOption.ReadOnly {
    override val minValue: Integer = impl.minValue(): Integer
    override val maxValue: Integer = impl.maxValue(): Integer
    override val score: Optional[EvaluationFormQuestionAnswerScore] =
      zio.aws.core.internal
        .optionalFromNullable(impl.score())
        .map(value =>
          zio.aws.connect.model.primitives
            .EvaluationFormQuestionAnswerScore(value)
        )
    override val automaticFail: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticFail())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionOption
  ): zio.aws.connect.model.EvaluationFormNumericQuestionOption.ReadOnly =
    new Wrapper(impl)
}
