package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class EvaluationFormNumericQuestionProperties(
    minValue: Integer,
    maxValue: Integer,
    options: Optional[
      Iterable[zio.aws.connect.model.EvaluationFormNumericQuestionOption]
    ] = Optional.Absent,
    automation: Optional[
      zio.aws.connect.model.EvaluationFormNumericQuestionAutomation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionProperties = {
    import EvaluationFormNumericQuestionProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionProperties
      .builder()
      .minValue(minValue: java.lang.Integer)
      .maxValue(maxValue: java.lang.Integer)
      .optionallyWith(
        options.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.options)
      .optionallyWith(automation.map(value => value.buildAwsValue()))(
        _.automation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.EvaluationFormNumericQuestionProperties.ReadOnly =
    zio.aws.connect.model.EvaluationFormNumericQuestionProperties
      .wrap(buildAwsValue())
}
object EvaluationFormNumericQuestionProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.EvaluationFormNumericQuestionProperties =
      zio.aws.connect.model.EvaluationFormNumericQuestionProperties(
        minValue,
        maxValue,
        options.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        automation.map(value => value.asEditable)
      )
    def minValue: Integer
    def maxValue: Integer
    def options: Optional[
      List[zio.aws.connect.model.EvaluationFormNumericQuestionOption.ReadOnly]
    ]
    def automation: Optional[
      zio.aws.connect.model.EvaluationFormNumericQuestionAutomation.ReadOnly
    ]
    def getMinValue: ZIO[Any, Nothing, Integer] = ZIO.succeed(minValue)
    def getMaxValue: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxValue)
    def getOptions: ZIO[Any, AwsError, List[
      zio.aws.connect.model.EvaluationFormNumericQuestionOption.ReadOnly
    ]] = AwsError.unwrapOptionField("options", options)
    def getAutomation: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormNumericQuestionAutomation.ReadOnly
    ] = AwsError.unwrapOptionField("automation", automation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionProperties
  ) extends zio.aws.connect.model.EvaluationFormNumericQuestionProperties.ReadOnly {
    override val minValue: Integer = impl.minValue(): Integer
    override val maxValue: Integer = impl.maxValue(): Integer
    override val options: Optional[
      List[zio.aws.connect.model.EvaluationFormNumericQuestionOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.EvaluationFormNumericQuestionOption.wrap(item)
        }.toList
      )
    override val automation: Optional[
      zio.aws.connect.model.EvaluationFormNumericQuestionAutomation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.automation())
      .map(value =>
        zio.aws.connect.model.EvaluationFormNumericQuestionAutomation
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionProperties
  ): zio.aws.connect.model.EvaluationFormNumericQuestionProperties.ReadOnly =
    new Wrapper(impl)
}
