package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  EvaluationFormItemWeight,
  ReferenceId,
  EvaluationFormQuestionInstructions,
  EvaluationFormQuestionTitle
}
import scala.jdk.CollectionConverters._
final case class EvaluationFormQuestion(
    title: EvaluationFormQuestionTitle,
    instructions: Optional[EvaluationFormQuestionInstructions] =
      Optional.Absent,
    refId: ReferenceId,
    notApplicableEnabled: Optional[Boolean] = Optional.Absent,
    questionType: zio.aws.connect.model.EvaluationFormQuestionType,
    questionTypeProperties: Optional[
      zio.aws.connect.model.EvaluationFormQuestionTypeProperties
    ] = Optional.Absent,
    weight: Optional[EvaluationFormItemWeight] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormQuestion = {
    import EvaluationFormQuestion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormQuestion
      .builder()
      .title(EvaluationFormQuestionTitle.unwrap(title): java.lang.String)
      .optionallyWith(
        instructions.map(value =>
          EvaluationFormQuestionInstructions.unwrap(value): java.lang.String
        )
      )(_.instructions)
      .refId(ReferenceId.unwrap(refId): java.lang.String)
      .optionallyWith(
        notApplicableEnabled.map(value => value: java.lang.Boolean)
      )(_.notApplicableEnabled)
      .questionType(questionType.unwrap)
      .optionallyWith(
        questionTypeProperties.map(value => value.buildAwsValue())
      )(_.questionTypeProperties)
      .optionallyWith(
        weight.map(value =>
          EvaluationFormItemWeight.unwrap(value): java.lang.Double
        )
      )(_.weight)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationFormQuestion.ReadOnly =
    zio.aws.connect.model.EvaluationFormQuestion.wrap(buildAwsValue())
}
object EvaluationFormQuestion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormQuestion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationFormQuestion =
      zio.aws.connect.model.EvaluationFormQuestion(
        title,
        instructions.map(value => value),
        refId,
        notApplicableEnabled.map(value => value),
        questionType,
        questionTypeProperties.map(value => value.asEditable),
        weight.map(value => value)
      )
    def title: EvaluationFormQuestionTitle
    def instructions: Optional[EvaluationFormQuestionInstructions]
    def refId: ReferenceId
    def notApplicableEnabled: Optional[Boolean]
    def questionType: zio.aws.connect.model.EvaluationFormQuestionType
    def questionTypeProperties: Optional[
      zio.aws.connect.model.EvaluationFormQuestionTypeProperties.ReadOnly
    ]
    def weight: Optional[EvaluationFormItemWeight]
    def getTitle: ZIO[Any, Nothing, EvaluationFormQuestionTitle] =
      ZIO.succeed(title)
    def getInstructions
        : ZIO[Any, AwsError, EvaluationFormQuestionInstructions] =
      AwsError.unwrapOptionField("instructions", instructions)
    def getRefId: ZIO[Any, Nothing, ReferenceId] = ZIO.succeed(refId)
    def getNotApplicableEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("notApplicableEnabled", notApplicableEnabled)
    def getQuestionType
        : ZIO[Any, Nothing, zio.aws.connect.model.EvaluationFormQuestionType] =
      ZIO.succeed(questionType)
    def getQuestionTypeProperties: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormQuestionTypeProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "questionTypeProperties",
      questionTypeProperties
    )
    def getWeight: ZIO[Any, AwsError, EvaluationFormItemWeight] =
      AwsError.unwrapOptionField("weight", weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormQuestion
  ) extends zio.aws.connect.model.EvaluationFormQuestion.ReadOnly {
    override val title: EvaluationFormQuestionTitle =
      zio.aws.connect.model.primitives.EvaluationFormQuestionTitle(impl.title())
    override val instructions: Optional[EvaluationFormQuestionInstructions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instructions())
        .map(value =>
          zio.aws.connect.model.primitives
            .EvaluationFormQuestionInstructions(value)
        )
    override val refId: ReferenceId =
      zio.aws.connect.model.primitives.ReferenceId(impl.refId())
    override val notApplicableEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.notApplicableEnabled())
      .map(value => value: Boolean)
    override val questionType
        : zio.aws.connect.model.EvaluationFormQuestionType =
      zio.aws.connect.model.EvaluationFormQuestionType.wrap(impl.questionType())
    override val questionTypeProperties: Optional[
      zio.aws.connect.model.EvaluationFormQuestionTypeProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.questionTypeProperties())
      .map(value =>
        zio.aws.connect.model.EvaluationFormQuestionTypeProperties.wrap(value)
      )
    override val weight: Optional[EvaluationFormItemWeight] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weight())
        .map(value =>
          zio.aws.connect.model.primitives.EvaluationFormItemWeight(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormQuestion
  ): zio.aws.connect.model.EvaluationFormQuestion.ReadOnly = new Wrapper(impl)
}
