package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationFormQuestionTypeProperties(
    numeric: Optional[
      zio.aws.connect.model.EvaluationFormNumericQuestionProperties
    ] = Optional.Absent,
    singleSelect: Optional[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormQuestionTypeProperties = {
    import EvaluationFormQuestionTypeProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormQuestionTypeProperties
      .builder()
      .optionallyWith(numeric.map(value => value.buildAwsValue()))(_.numeric)
      .optionallyWith(singleSelect.map(value => value.buildAwsValue()))(
        _.singleSelect
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.EvaluationFormQuestionTypeProperties.ReadOnly =
    zio.aws.connect.model.EvaluationFormQuestionTypeProperties
      .wrap(buildAwsValue())
}
object EvaluationFormQuestionTypeProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormQuestionTypeProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationFormQuestionTypeProperties =
      zio.aws.connect.model.EvaluationFormQuestionTypeProperties(
        numeric.map(value => value.asEditable),
        singleSelect.map(value => value.asEditable)
      )
    def numeric: Optional[
      zio.aws.connect.model.EvaluationFormNumericQuestionProperties.ReadOnly
    ]
    def singleSelect: Optional[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionProperties.ReadOnly
    ]
    def getNumeric: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormNumericQuestionProperties.ReadOnly
    ] = AwsError.unwrapOptionField("numeric", numeric)
    def getSingleSelect: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionProperties.ReadOnly
    ] = AwsError.unwrapOptionField("singleSelect", singleSelect)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormQuestionTypeProperties
  ) extends zio.aws.connect.model.EvaluationFormQuestionTypeProperties.ReadOnly {
    override val numeric: Optional[
      zio.aws.connect.model.EvaluationFormNumericQuestionProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.numeric())
      .map(value =>
        zio.aws.connect.model.EvaluationFormNumericQuestionProperties
          .wrap(value)
      )
    override val singleSelect: Optional[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.singleSelect())
      .map(value =>
        zio.aws.connect.model.EvaluationFormSingleSelectQuestionProperties
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormQuestionTypeProperties
  ): zio.aws.connect.model.EvaluationFormQuestionTypeProperties.ReadOnly =
    new Wrapper(impl)
}
