package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait EvaluationFormScoringMode {
  def unwrap
      : software.amazon.awssdk.services.connect.model.EvaluationFormScoringMode
}
object EvaluationFormScoringMode {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.EvaluationFormScoringMode
  ): zio.aws.connect.model.EvaluationFormScoringMode = value match {
    case software.amazon.awssdk.services.connect.model.EvaluationFormScoringMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.EvaluationFormScoringMode.QUESTION_ONLY =>
      val r = QUESTION_ONLY
      r
    case software.amazon.awssdk.services.connect.model.EvaluationFormScoringMode.SECTION_ONLY =>
      val r = SECTION_ONLY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.EvaluationFormScoringMode {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EvaluationFormScoringMode =
      software.amazon.awssdk.services.connect.model.EvaluationFormScoringMode.UNKNOWN_TO_SDK_VERSION
  }
  case object QUESTION_ONLY
      extends zio.aws.connect.model.EvaluationFormScoringMode {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EvaluationFormScoringMode =
      software.amazon.awssdk.services.connect.model.EvaluationFormScoringMode.QUESTION_ONLY
  }
  case object SECTION_ONLY
      extends zio.aws.connect.model.EvaluationFormScoringMode {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EvaluationFormScoringMode =
      software.amazon.awssdk.services.connect.model.EvaluationFormScoringMode.SECTION_ONLY
  }
}
