package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EvaluationFormScoringStrategy(
    mode: zio.aws.connect.model.EvaluationFormScoringMode,
    status: zio.aws.connect.model.EvaluationFormScoringStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormScoringStrategy = {
    import EvaluationFormScoringStrategy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormScoringStrategy
      .builder()
      .mode(mode.unwrap)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly =
    zio.aws.connect.model.EvaluationFormScoringStrategy.wrap(buildAwsValue())
}
object EvaluationFormScoringStrategy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormScoringStrategy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationFormScoringStrategy =
      zio.aws.connect.model.EvaluationFormScoringStrategy(mode, status)
    def mode: zio.aws.connect.model.EvaluationFormScoringMode
    def status: zio.aws.connect.model.EvaluationFormScoringStatus
    def getMode
        : ZIO[Any, Nothing, zio.aws.connect.model.EvaluationFormScoringMode] =
      ZIO.succeed(mode)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.connect.model.EvaluationFormScoringStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormScoringStrategy
  ) extends zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly {
    override val mode: zio.aws.connect.model.EvaluationFormScoringMode =
      zio.aws.connect.model.EvaluationFormScoringMode.wrap(impl.mode())
    override val status: zio.aws.connect.model.EvaluationFormScoringStatus =
      zio.aws.connect.model.EvaluationFormScoringStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormScoringStrategy
  ): zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly = new Wrapper(
    impl
  )
}
