package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  EvaluationFormItemWeight,
  EvaluationFormQuestionInstructions,
  ReferenceId,
  EvaluationFormSectionTitle
}
import scala.jdk.CollectionConverters._
final case class EvaluationFormSection(
    title: EvaluationFormSectionTitle,
    refId: ReferenceId,
    instructions: Optional[EvaluationFormQuestionInstructions] =
      Optional.Absent,
    items: Iterable[zio.aws.connect.model.EvaluationFormItem],
    weight: Optional[EvaluationFormItemWeight] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormSection = {
    import EvaluationFormSection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormSection
      .builder()
      .title(EvaluationFormSectionTitle.unwrap(title): java.lang.String)
      .refId(ReferenceId.unwrap(refId): java.lang.String)
      .optionallyWith(
        instructions.map(value =>
          EvaluationFormQuestionInstructions.unwrap(value): java.lang.String
        )
      )(_.instructions)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        weight.map(value =>
          EvaluationFormItemWeight.unwrap(value): java.lang.Double
        )
      )(_.weight)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationFormSection.ReadOnly =
    zio.aws.connect.model.EvaluationFormSection.wrap(buildAwsValue())
}
object EvaluationFormSection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormSection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationFormSection =
      zio.aws.connect.model.EvaluationFormSection(
        title,
        refId,
        instructions.map(value => value),
        items.map { item =>
          item.asEditable
        },
        weight.map(value => value)
      )
    def title: EvaluationFormSectionTitle
    def refId: ReferenceId
    def instructions: Optional[EvaluationFormQuestionInstructions]
    def items: List[zio.aws.connect.model.EvaluationFormItem.ReadOnly]
    def weight: Optional[EvaluationFormItemWeight]
    def getTitle: ZIO[Any, Nothing, EvaluationFormSectionTitle] =
      ZIO.succeed(title)
    def getRefId: ZIO[Any, Nothing, ReferenceId] = ZIO.succeed(refId)
    def getInstructions
        : ZIO[Any, AwsError, EvaluationFormQuestionInstructions] =
      AwsError.unwrapOptionField("instructions", instructions)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.connect.model.EvaluationFormItem.ReadOnly
    ]] = ZIO.succeed(items)
    def getWeight: ZIO[Any, AwsError, EvaluationFormItemWeight] =
      AwsError.unwrapOptionField("weight", weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSection
  ) extends zio.aws.connect.model.EvaluationFormSection.ReadOnly {
    override val title: EvaluationFormSectionTitle =
      zio.aws.connect.model.primitives.EvaluationFormSectionTitle(impl.title())
    override val refId: ReferenceId =
      zio.aws.connect.model.primitives.ReferenceId(impl.refId())
    override val instructions: Optional[EvaluationFormQuestionInstructions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instructions())
        .map(value =>
          zio.aws.connect.model.primitives
            .EvaluationFormQuestionInstructions(value)
        )
    override val items
        : List[zio.aws.connect.model.EvaluationFormItem.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.connect.model.EvaluationFormItem.wrap(item)
      }
      .toList
    override val weight: Optional[EvaluationFormItemWeight] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weight())
        .map(value =>
          zio.aws.connect.model.primitives.EvaluationFormItemWeight(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSection
  ): zio.aws.connect.model.EvaluationFormSection.ReadOnly = new Wrapper(impl)
}
