package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.ReferenceId
import scala.jdk.CollectionConverters._
final case class EvaluationFormSingleSelectQuestionAutomation(
    options: Iterable[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomationOption
    ],
    defaultOptionRefId: Optional[ReferenceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomation = {
    import EvaluationFormSingleSelectQuestionAutomation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomation
      .builder()
      .options(options.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        defaultOptionRefId.map(value =>
          ReferenceId.unwrap(value): java.lang.String
        )
      )(_.defaultOptionRefId)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomation.ReadOnly =
    zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomation
      .wrap(buildAwsValue())
}
object EvaluationFormSingleSelectQuestionAutomation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomation =
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomation(
        options.map { item =>
          item.asEditable
        },
        defaultOptionRefId.map(value => value)
      )
    def options: List[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomationOption.ReadOnly
    ]
    def defaultOptionRefId: Optional[ReferenceId]
    def getOptions: ZIO[Any, Nothing, List[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomationOption.ReadOnly
    ]] = ZIO.succeed(options)
    def getDefaultOptionRefId: ZIO[Any, AwsError, ReferenceId] =
      AwsError.unwrapOptionField("defaultOptionRefId", defaultOptionRefId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomation
  ) extends zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomation.ReadOnly {
    override val options: List[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomationOption.ReadOnly
    ] = impl
      .options()
      .asScala
      .map { item =>
        zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomationOption
          .wrap(item)
      }
      .toList
    override val defaultOptionRefId: Optional[ReferenceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultOptionRefId())
        .map(value => zio.aws.connect.model.primitives.ReferenceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomation
  ): zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomation.ReadOnly =
    new Wrapper(impl)
}
