package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationFormSingleSelectQuestionAutomationOption(
    ruleCategory: Optional[
      zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomationOption = {
    import EvaluationFormSingleSelectQuestionAutomationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomationOption
      .builder()
      .optionallyWith(ruleCategory.map(value => value.buildAwsValue()))(
        _.ruleCategory
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomationOption.ReadOnly =
    zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomationOption
      .wrap(buildAwsValue())
}
object EvaluationFormSingleSelectQuestionAutomationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomationOption =
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomationOption(
        ruleCategory.map(value => value.asEditable)
      )
    def ruleCategory: Optional[
      zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomation.ReadOnly
    ]
    def getRuleCategory: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomation.ReadOnly
    ] = AwsError.unwrapOptionField("ruleCategory", ruleCategory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomationOption
  ) extends zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomationOption.ReadOnly {
    override val ruleCategory: Optional[
      zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleCategory())
      .map(value =>
        zio.aws.connect.model.SingleSelectQuestionRuleCategoryAutomation
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomationOption
  ): zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomationOption.ReadOnly =
    new Wrapper(impl)
}
