package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  EvaluationFormQuestionAnswerScore,
  EvaluationFormSingleSelectQuestionOptionText,
  ReferenceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EvaluationFormSingleSelectQuestionOption(
    refId: ReferenceId,
    text: EvaluationFormSingleSelectQuestionOptionText,
    score: Optional[EvaluationFormQuestionAnswerScore] = Optional.Absent,
    automaticFail: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionOption = {
    import EvaluationFormSingleSelectQuestionOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionOption
      .builder()
      .refId(ReferenceId.unwrap(refId): java.lang.String)
      .text(
        EvaluationFormSingleSelectQuestionOptionText.unwrap(
          text
        ): java.lang.String
      )
      .optionallyWith(
        score.map(value =>
          EvaluationFormQuestionAnswerScore.unwrap(value): Integer
        )
      )(_.score)
      .optionallyWith(automaticFail.map(value => value: java.lang.Boolean))(
        _.automaticFail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.EvaluationFormSingleSelectQuestionOption.ReadOnly =
    zio.aws.connect.model.EvaluationFormSingleSelectQuestionOption
      .wrap(buildAwsValue())
}
object EvaluationFormSingleSelectQuestionOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.EvaluationFormSingleSelectQuestionOption =
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionOption(
        refId,
        text,
        score.map(value => value),
        automaticFail.map(value => value)
      )
    def refId: ReferenceId
    def text: EvaluationFormSingleSelectQuestionOptionText
    def score: Optional[EvaluationFormQuestionAnswerScore]
    def automaticFail: Optional[Boolean]
    def getRefId: ZIO[Any, Nothing, ReferenceId] = ZIO.succeed(refId)
    def getText
        : ZIO[Any, Nothing, EvaluationFormSingleSelectQuestionOptionText] =
      ZIO.succeed(text)
    def getScore: ZIO[Any, AwsError, EvaluationFormQuestionAnswerScore] =
      AwsError.unwrapOptionField("score", score)
    def getAutomaticFail: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("automaticFail", automaticFail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionOption
  ) extends zio.aws.connect.model.EvaluationFormSingleSelectQuestionOption.ReadOnly {
    override val refId: ReferenceId =
      zio.aws.connect.model.primitives.ReferenceId(impl.refId())
    override val text: EvaluationFormSingleSelectQuestionOptionText =
      zio.aws.connect.model.primitives
        .EvaluationFormSingleSelectQuestionOptionText(impl.text())
    override val score: Optional[EvaluationFormQuestionAnswerScore] =
      zio.aws.core.internal
        .optionalFromNullable(impl.score())
        .map(value =>
          zio.aws.connect.model.primitives
            .EvaluationFormQuestionAnswerScore(value)
        )
    override val automaticFail: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticFail())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionOption
  ): zio.aws.connect.model.EvaluationFormSingleSelectQuestionOption.ReadOnly =
    new Wrapper(impl)
}
