package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationFormSingleSelectQuestionProperties(
    options: Iterable[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionOption
    ],
    displayAs: Optional[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionDisplayMode
    ] = Optional.Absent,
    automation: Optional[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionProperties = {
    import EvaluationFormSingleSelectQuestionProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionProperties
      .builder()
      .options(options.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(displayAs.map(value => value.unwrap))(_.displayAs)
      .optionallyWith(automation.map(value => value.buildAwsValue()))(
        _.automation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.EvaluationFormSingleSelectQuestionProperties.ReadOnly =
    zio.aws.connect.model.EvaluationFormSingleSelectQuestionProperties
      .wrap(buildAwsValue())
}
object EvaluationFormSingleSelectQuestionProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.EvaluationFormSingleSelectQuestionProperties =
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionProperties(
        options.map { item =>
          item.asEditable
        },
        displayAs.map(value => value),
        automation.map(value => value.asEditable)
      )
    def options: List[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionOption.ReadOnly
    ]
    def displayAs: Optional[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionDisplayMode
    ]
    def automation: Optional[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomation.ReadOnly
    ]
    def getOptions: ZIO[Any, Nothing, List[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionOption.ReadOnly
    ]] = ZIO.succeed(options)
    def getDisplayAs: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionDisplayMode
    ] = AwsError.unwrapOptionField("displayAs", displayAs)
    def getAutomation: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomation.ReadOnly
    ] = AwsError.unwrapOptionField("automation", automation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionProperties
  ) extends zio.aws.connect.model.EvaluationFormSingleSelectQuestionProperties.ReadOnly {
    override val options: List[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionOption.ReadOnly
    ] = impl
      .options()
      .asScala
      .map { item =>
        zio.aws.connect.model.EvaluationFormSingleSelectQuestionOption
          .wrap(item)
      }
      .toList
    override val displayAs: Optional[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionDisplayMode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.displayAs())
      .map(value =>
        zio.aws.connect.model.EvaluationFormSingleSelectQuestionDisplayMode
          .wrap(value)
      )
    override val automation: Optional[
      zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.automation())
      .map(value =>
        zio.aws.connect.model.EvaluationFormSingleSelectQuestionAutomation
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionProperties
  ): zio.aws.connect.model.EvaluationFormSingleSelectQuestionProperties.ReadOnly =
    new Wrapper(impl)
}
