package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  Timestamp,
  VersionNumber,
  ResourceId,
  EvaluationFormTitle,
  ARN
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EvaluationFormSummary(
    evaluationFormId: ResourceId,
    evaluationFormArn: ARN,
    title: EvaluationFormTitle,
    createdTime: Timestamp,
    createdBy: ARN,
    lastModifiedTime: Timestamp,
    lastModifiedBy: ARN,
    lastActivatedTime: Optional[Timestamp] = Optional.Absent,
    lastActivatedBy: Optional[ARN] = Optional.Absent,
    latestVersion: VersionNumber,
    activeVersion: Optional[VersionNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormSummary = {
    import EvaluationFormSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormSummary
      .builder()
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .evaluationFormArn(ARN.unwrap(evaluationFormArn): java.lang.String)
      .title(EvaluationFormTitle.unwrap(title): java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .createdBy(ARN.unwrap(createdBy): java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .lastModifiedBy(ARN.unwrap(lastModifiedBy): java.lang.String)
      .optionallyWith(
        lastActivatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastActivatedTime)
      .optionallyWith(
        lastActivatedBy.map(value => ARN.unwrap(value): java.lang.String)
      )(_.lastActivatedBy)
      .latestVersion(VersionNumber.unwrap(latestVersion): Integer)
      .optionallyWith(
        activeVersion.map(value => VersionNumber.unwrap(value): Integer)
      )(_.activeVersion)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationFormSummary.ReadOnly =
    zio.aws.connect.model.EvaluationFormSummary.wrap(buildAwsValue())
}
object EvaluationFormSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationFormSummary =
      zio.aws.connect.model.EvaluationFormSummary(
        evaluationFormId,
        evaluationFormArn,
        title,
        createdTime,
        createdBy,
        lastModifiedTime,
        lastModifiedBy,
        lastActivatedTime.map(value => value),
        lastActivatedBy.map(value => value),
        latestVersion,
        activeVersion.map(value => value)
      )
    def evaluationFormId: ResourceId
    def evaluationFormArn: ARN
    def title: EvaluationFormTitle
    def createdTime: Timestamp
    def createdBy: ARN
    def lastModifiedTime: Timestamp
    def lastModifiedBy: ARN
    def lastActivatedTime: Optional[Timestamp]
    def lastActivatedBy: Optional[ARN]
    def latestVersion: VersionNumber
    def activeVersion: Optional[VersionNumber]
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getEvaluationFormArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(evaluationFormArn)
    def getTitle: ZIO[Any, Nothing, EvaluationFormTitle] = ZIO.succeed(title)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getCreatedBy: ZIO[Any, Nothing, ARN] = ZIO.succeed(createdBy)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getLastModifiedBy: ZIO[Any, Nothing, ARN] = ZIO.succeed(lastModifiedBy)
    def getLastActivatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastActivatedTime", lastActivatedTime)
    def getLastActivatedBy: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("lastActivatedBy", lastActivatedBy)
    def getLatestVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(latestVersion)
    def getActiveVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("activeVersion", activeVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSummary
  ) extends zio.aws.connect.model.EvaluationFormSummary.ReadOnly {
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val evaluationFormArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluationFormArn())
    override val title: EvaluationFormTitle =
      zio.aws.connect.model.primitives.EvaluationFormTitle(impl.title())
    override val createdTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.createdTime())
    override val createdBy: ARN =
      zio.aws.connect.model.primitives.ARN(impl.createdBy())
    override val lastModifiedTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.lastModifiedTime())
    override val lastModifiedBy: ARN =
      zio.aws.connect.model.primitives.ARN(impl.lastModifiedBy())
    override val lastActivatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastActivatedTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val lastActivatedBy: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.lastActivatedBy())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val latestVersion: VersionNumber =
      zio.aws.connect.model.primitives.VersionNumber(impl.latestVersion())
    override val activeVersion: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.activeVersion())
      .map(value => zio.aws.connect.model.primitives.VersionNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormSummary
  ): zio.aws.connect.model.EvaluationFormSummary.ReadOnly = new Wrapper(impl)
}
