package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  Timestamp,
  EvaluationFormVersionIsLocked,
  VersionNumber,
  ResourceId,
  ARN
}
import java.time.Instant
import zio.aws.core.BuilderHelper
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EvaluationFormVersionSummary(
    evaluationFormArn: ARN,
    evaluationFormId: ResourceId,
    evaluationFormVersion: VersionNumber,
    locked: EvaluationFormVersionIsLocked,
    status: zio.aws.connect.model.EvaluationFormVersionStatus,
    createdTime: Timestamp,
    createdBy: ARN,
    lastModifiedTime: Timestamp,
    lastModifiedBy: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationFormVersionSummary = {
    import EvaluationFormVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationFormVersionSummary
      .builder()
      .evaluationFormArn(ARN.unwrap(evaluationFormArn): java.lang.String)
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .evaluationFormVersion(
        VersionNumber.unwrap(evaluationFormVersion): Integer
      )
      .locked(EvaluationFormVersionIsLocked.unwrap(locked): java.lang.Boolean)
      .status(status.unwrap)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .createdBy(ARN.unwrap(createdBy): java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .lastModifiedBy(ARN.unwrap(lastModifiedBy): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationFormVersionSummary.ReadOnly =
    zio.aws.connect.model.EvaluationFormVersionSummary.wrap(buildAwsValue())
}
object EvaluationFormVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationFormVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationFormVersionSummary =
      zio.aws.connect.model.EvaluationFormVersionSummary(
        evaluationFormArn,
        evaluationFormId,
        evaluationFormVersion,
        locked,
        status,
        createdTime,
        createdBy,
        lastModifiedTime,
        lastModifiedBy
      )
    def evaluationFormArn: ARN
    def evaluationFormId: ResourceId
    def evaluationFormVersion: VersionNumber
    def locked: EvaluationFormVersionIsLocked
    def status: zio.aws.connect.model.EvaluationFormVersionStatus
    def createdTime: Timestamp
    def createdBy: ARN
    def lastModifiedTime: Timestamp
    def lastModifiedBy: ARN
    def getEvaluationFormArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(evaluationFormArn)
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getEvaluationFormVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(evaluationFormVersion)
    def getLocked: ZIO[Any, Nothing, EvaluationFormVersionIsLocked] =
      ZIO.succeed(locked)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.connect.model.EvaluationFormVersionStatus] =
      ZIO.succeed(status)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getCreatedBy: ZIO[Any, Nothing, ARN] = ZIO.succeed(createdBy)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getLastModifiedBy: ZIO[Any, Nothing, ARN] = ZIO.succeed(lastModifiedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormVersionSummary
  ) extends zio.aws.connect.model.EvaluationFormVersionSummary.ReadOnly {
    override val evaluationFormArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluationFormArn())
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val evaluationFormVersion: VersionNumber =
      zio.aws.connect.model.primitives
        .VersionNumber(impl.evaluationFormVersion())
    override val locked: EvaluationFormVersionIsLocked =
      zio.aws.connect.model.primitives
        .EvaluationFormVersionIsLocked(impl.locked())
    override val status: zio.aws.connect.model.EvaluationFormVersionStatus =
      zio.aws.connect.model.EvaluationFormVersionStatus.wrap(impl.status())
    override val createdTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.createdTime())
    override val createdBy: ARN =
      zio.aws.connect.model.primitives.ARN(impl.createdBy())
    override val lastModifiedTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.lastModifiedTime())
    override val lastModifiedBy: ARN =
      zio.aws.connect.model.primitives.ARN(impl.lastModifiedBy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationFormVersionSummary
  ): zio.aws.connect.model.EvaluationFormVersionSummary.ReadOnly = new Wrapper(
    impl
  )
}
