package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ResourceId, ARN, ContactId}
import scala.jdk.CollectionConverters._
final case class EvaluationMetadata(
    contactId: ContactId,
    evaluatorArn: ARN,
    contactAgentId: Optional[ResourceId] = Optional.Absent,
    score: Optional[zio.aws.connect.model.EvaluationScore] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationMetadata = {
    import EvaluationMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationMetadata
      .builder()
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .evaluatorArn(ARN.unwrap(evaluatorArn): java.lang.String)
      .optionallyWith(
        contactAgentId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.contactAgentId)
      .optionallyWith(score.map(value => value.buildAwsValue()))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationMetadata.ReadOnly =
    zio.aws.connect.model.EvaluationMetadata.wrap(buildAwsValue())
}
object EvaluationMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationMetadata =
      zio.aws.connect.model.EvaluationMetadata(
        contactId,
        evaluatorArn,
        contactAgentId.map(value => value),
        score.map(value => value.asEditable)
      )
    def contactId: ContactId
    def evaluatorArn: ARN
    def contactAgentId: Optional[ResourceId]
    def score: Optional[zio.aws.connect.model.EvaluationScore.ReadOnly]
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getEvaluatorArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(evaluatorArn)
    def getContactAgentId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("contactAgentId", contactAgentId)
    def getScore
        : ZIO[Any, AwsError, zio.aws.connect.model.EvaluationScore.ReadOnly] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationMetadata
  ) extends zio.aws.connect.model.EvaluationMetadata.ReadOnly {
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val evaluatorArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluatorArn())
    override val contactAgentId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.contactAgentId())
      .map(value => zio.aws.connect.model.primitives.ResourceId(value))
    override val score
        : Optional[zio.aws.connect.model.EvaluationScore.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.score())
        .map(value => zio.aws.connect.model.EvaluationScore.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationMetadata
  ): zio.aws.connect.model.EvaluationMetadata.ReadOnly = new Wrapper(impl)
}
