package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.EvaluationNoteString
import scala.jdk.CollectionConverters._
final case class EvaluationNote(
    value: Optional[EvaluationNoteString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationNote = {
    import EvaluationNote.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationNote
      .builder()
      .optionallyWith(
        value.map(value => EvaluationNoteString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationNote.ReadOnly =
    zio.aws.connect.model.EvaluationNote.wrap(buildAwsValue())
}
object EvaluationNote {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationNote
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationNote =
      zio.aws.connect.model.EvaluationNote(value.map(value => value))
    def value: Optional[EvaluationNoteString]
    def getValue: ZIO[Any, AwsError, EvaluationNoteString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationNote
  ) extends zio.aws.connect.model.EvaluationNote.ReadOnly {
    override val value: Optional[EvaluationNoteString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.connect.model.primitives.EvaluationNoteString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationNote
  ): zio.aws.connect.model.EvaluationNote.ReadOnly = new Wrapper(impl)
}
