package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.EvaluationScorePercentage
import scala.jdk.CollectionConverters._
final case class EvaluationScore(
    percentage: Optional[EvaluationScorePercentage] = Optional.Absent,
    notApplicable: Optional[Boolean] = Optional.Absent,
    automaticFail: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationScore = {
    import EvaluationScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationScore
      .builder()
      .optionallyWith(
        percentage.map(value =>
          EvaluationScorePercentage.unwrap(value): java.lang.Double
        )
      )(_.percentage)
      .optionallyWith(notApplicable.map(value => value: java.lang.Boolean))(
        _.notApplicable
      )
      .optionallyWith(automaticFail.map(value => value: java.lang.Boolean))(
        _.automaticFail
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationScore.ReadOnly =
    zio.aws.connect.model.EvaluationScore.wrap(buildAwsValue())
}
object EvaluationScore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationScore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationScore =
      zio.aws.connect.model.EvaluationScore(
        percentage.map(value => value),
        notApplicable.map(value => value),
        automaticFail.map(value => value)
      )
    def percentage: Optional[EvaluationScorePercentage]
    def notApplicable: Optional[Boolean]
    def automaticFail: Optional[Boolean]
    def getPercentage: ZIO[Any, AwsError, EvaluationScorePercentage] =
      AwsError.unwrapOptionField("percentage", percentage)
    def getNotApplicable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("notApplicable", notApplicable)
    def getAutomaticFail: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("automaticFail", automaticFail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationScore
  ) extends zio.aws.connect.model.EvaluationScore.ReadOnly {
    override val percentage: Optional[EvaluationScorePercentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.percentage())
        .map(value =>
          zio.aws.connect.model.primitives.EvaluationScorePercentage(value)
        )
    override val notApplicable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.notApplicable())
      .map(value => value: Boolean)
    override val automaticFail: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticFail())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationScore
  ): zio.aws.connect.model.EvaluationScore.ReadOnly = new Wrapper(impl)
}
