package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait EvaluationStatus {
  def unwrap: software.amazon.awssdk.services.connect.model.EvaluationStatus
}
object EvaluationStatus {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.EvaluationStatus
  ): zio.aws.connect.model.EvaluationStatus = value match {
    case software.amazon.awssdk.services.connect.model.EvaluationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.EvaluationStatus.DRAFT =>
      val r = DRAFT
      r
    case software.amazon.awssdk.services.connect.model.EvaluationStatus.SUBMITTED =>
      val r = SUBMITTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.EvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EvaluationStatus =
      software.amazon.awssdk.services.connect.model.EvaluationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DRAFT extends zio.aws.connect.model.EvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EvaluationStatus =
      software.amazon.awssdk.services.connect.model.EvaluationStatus.DRAFT
  }
  case object SUBMITTED extends zio.aws.connect.model.EvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.EvaluationStatus =
      software.amazon.awssdk.services.connect.model.EvaluationStatus.SUBMITTED
  }
}
