package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  Timestamp,
  EvaluationFormTitle,
  ARN,
  ResourceId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class EvaluationSummary(
    evaluationId: ResourceId,
    evaluationArn: ARN,
    evaluationFormTitle: EvaluationFormTitle,
    evaluationFormId: ResourceId,
    status: zio.aws.connect.model.EvaluationStatus,
    evaluatorArn: ARN,
    score: Optional[zio.aws.connect.model.EvaluationScore] = Optional.Absent,
    createdTime: Timestamp,
    lastModifiedTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.EvaluationSummary = {
    import EvaluationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.EvaluationSummary
      .builder()
      .evaluationId(ResourceId.unwrap(evaluationId): java.lang.String)
      .evaluationArn(ARN.unwrap(evaluationArn): java.lang.String)
      .evaluationFormTitle(
        EvaluationFormTitle.unwrap(evaluationFormTitle): java.lang.String
      )
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .status(status.unwrap)
      .evaluatorArn(ARN.unwrap(evaluatorArn): java.lang.String)
      .optionallyWith(score.map(value => value.buildAwsValue()))(_.score)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.EvaluationSummary.ReadOnly =
    zio.aws.connect.model.EvaluationSummary.wrap(buildAwsValue())
}
object EvaluationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.EvaluationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.EvaluationSummary =
      zio.aws.connect.model.EvaluationSummary(
        evaluationId,
        evaluationArn,
        evaluationFormTitle,
        evaluationFormId,
        status,
        evaluatorArn,
        score.map(value => value.asEditable),
        createdTime,
        lastModifiedTime
      )
    def evaluationId: ResourceId
    def evaluationArn: ARN
    def evaluationFormTitle: EvaluationFormTitle
    def evaluationFormId: ResourceId
    def status: zio.aws.connect.model.EvaluationStatus
    def evaluatorArn: ARN
    def score: Optional[zio.aws.connect.model.EvaluationScore.ReadOnly]
    def createdTime: Timestamp
    def lastModifiedTime: Timestamp
    def getEvaluationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationId)
    def getEvaluationArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(evaluationArn)
    def getEvaluationFormTitle: ZIO[Any, Nothing, EvaluationFormTitle] =
      ZIO.succeed(evaluationFormTitle)
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getStatus: ZIO[Any, Nothing, zio.aws.connect.model.EvaluationStatus] =
      ZIO.succeed(status)
    def getEvaluatorArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(evaluatorArn)
    def getScore
        : ZIO[Any, AwsError, zio.aws.connect.model.EvaluationScore.ReadOnly] =
      AwsError.unwrapOptionField("score", score)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.EvaluationSummary
  ) extends zio.aws.connect.model.EvaluationSummary.ReadOnly {
    override val evaluationId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationId())
    override val evaluationArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluationArn())
    override val evaluationFormTitle: EvaluationFormTitle =
      zio.aws.connect.model.primitives
        .EvaluationFormTitle(impl.evaluationFormTitle())
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val status: zio.aws.connect.model.EvaluationStatus =
      zio.aws.connect.model.EvaluationStatus.wrap(impl.status())
    override val evaluatorArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluatorArn())
    override val score
        : Optional[zio.aws.connect.model.EvaluationScore.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.score())
        .map(value => zio.aws.connect.model.EvaluationScore.wrap(value))
    override val createdTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.createdTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.connect.model.primitives.Timestamp(impl.lastModifiedTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.EvaluationSummary
  ): zio.aws.connect.model.EvaluationSummary.ReadOnly = new Wrapper(impl)
}
